<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
}

if (!isset($_GET['id']) && $_SESSION['role'] != 'eleve' && $_SESSION['id'] != '') {
    header("Location: eleves.php");
}

if ($_SESSION['role'] != 'eleve') {
    $id = $_GET['id'];
}
else {
    $id = $_SESSION['id_eleve'];
}

include 'include/head.php';
include 'include/navigation.php';

$requete_eleve = $bdd->prepare("SELECT nom, prenom FROM eleve WHERE id_eleve=:id");
$requete_eleve->bindParam(':id', $id);
$requete_eleve->execute();
$eleve = $requete_eleve->fetch();

if (!$eleve) {
    die('ID élève invalide');
}
?>

    <!-- Page Content -->
    <div id="page-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <h1 class="page-header">Bienvenue <?php echo htmlspecialchars($_SESSION['user']) ?></h1>
                </div>
                <!-- /.col-lg-12 -->
            </div>
            <!-- /.row -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            Bulletin de <?php echo htmlspecialchars($eleve['prenom'].' '.$eleve['nom']) ?>
                        </div>
                        <!-- /.panel-heading -->
                        <div class="panel-body">
                            <div class="dataTable_wrapper">
                                <table class="table table-striped table-bordered table-hover" id="dataTables-example">
                                    <thead>
                                    <tr>
                                        <th>Cours</th>
                                        <th>Professeur(s)</th>
                                        <th>Coefficients</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    $result = $bdd->prepare("SELECT id_cours, nom_cours, id_groupe2 FROM eleve, cours, groupe_eleve, groupe WHERE eleve.id_eleve=groupe_eleve.id_eleve4 AND groupe_eleve.id_groupe=groupe.id AND groupe_eleve.id_eleve4=eleve.id_eleve AND groupe_eleve.id_groupe=cours.id_groupe2 AND id_eleve=:id");
                                    $result->bindParam(':id', $id);
                                    $result->execute();
                                    while ($ligne = $result->fetch())
                                    {
                                        $requete = $bdd->prepare("SELECT nom FROM groupe WHERE id=:id");
                                        $requete->bindParam(':id', $ligne['id_groupe2']);
                                        $requete->execute();
                                        if ($requete->rowCount() > 0) {
                                            while ($nom = $requete->fetch())
                                            {
                                                $requete2 = $bdd->prepare("SELECT id_professeur FROM enseigne_le_cours WHERE id_cours=:id");
                                                $requete2->bindParam(':id', $ligne['id_cours']);
                                                $requete2->execute();
                                                ?>
                                                <tr class="odd">
                                                <?php if ($_SESSION['role'] == 'admin') : ?>
                                                <td><a href="edition-cours.php?id=<?php echo htmlspecialchars($ligne['id_cours']) ?>"><?php echo htmlspecialchars($ligne['nom_cours']) ?></a></td>
                                                <?php else: ?>
                                                <td><?php echo htmlspecialchars($ligne['nom_cours']) ?></td>
                                                <?php endif; ?>
                                                <td>
                                                    <?php
                                                    while ($id_prof = $requete2->fetch())
                                                    {
                                                        $requete3 = $bdd->prepare("SELECT id_professeur, nom_professeur, prenom_professeur FROM professeur WHERE id_professeur=:id");
                                                        $requete3->bindParam(':id', $id_prof['id_professeur']);
                                                        $requete3->execute();
                                                        $row = $requete3->fetch();
                                                        echo htmlspecialchars($row['prenom_professeur'].' '.$row['nom_professeur']).'<br />';
                                                    }
                                                    ?> </td> <td>
                                                <?php
                                                $moyenne = $compteur = 0;
                                                $requete4 = $bdd->prepare("SELECT note, id_note_cours, type_note, coefficient FROM coefficient, note WHERE note.note_id=coefficient.id_note_cours AND id_cours3=:id AND eleve_id=:eleve_id");
                                                $requete4->bindParam(':id', $ligne['id_cours']);
                                                $requete4->bindParam(':eleve_id', $id);
                                                $requete4->execute();
                                                while ($coeff = $requete4->fetch())
                                                {
                                                    $compteur++;
                                                    $moyenne += $coeff['note'];
                                                    echo htmlspecialchars($coeff['type_note'].' ('.$coeff['coefficient']).') : '.htmlspecialchars($coeff['note']);
                                                    echo '<br />';
                                                }
                                                $requete5 = $bdd->prepare("SELECT id_note_cours, type_note, coefficient FROM coefficient WHERE id_cours3=:id AND id_note_cours NOT IN (SELECT id_note_cours FROM coefficient, note WHERE note.note_id=coefficient.id_note_cours AND id_cours3=:id AND eleve_id=:eleve_id)");
                                                $requete5->bindParam(':id', $ligne['id_cours']);
                                                $requete5->bindParam(':eleve_id', $id);
                                                $requete5->execute();
                                                while ($coeff = $requete5->fetch())
                                                {
                                                    $compteur++;
                                                    $moyenne += 0;
                                                    echo htmlspecialchars($coeff['type_note'].' ('.$coeff['coefficient']).') : 0 (pas de note enregistrée)';
                                                    echo '<br />';
                                                }
                                                if ($compteur != 0) {
                                                    $moyenne /= $compteur;
                                                    echo 'Moyenne matière : '.round($moyenne, 2);
                                                }
                                                ?> </td> <?php
                                            }
                                        }
                                        else {
                                            ?>
                                            <td>Aucun groupe</td>
                                            <td>Aucun groupe</td>
                                            <td>Aucun groupe</td>
                                            <?php
                                        }
                                        ?>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                            </div>
                            <!-- /.table-responsive -->
                        </div>
                        <!-- /.panel-body -->
                    </div>
                    <!-- /.panel -->
                </div>
                <!-- /.col-lg-12 -->
            </div>
        </div>
        <!-- /.container-fluid -->
    </div>
    <!-- /#page-wrapper -->

<?php
include 'include/foot.php';
